<?php
// projekTA/web/login.php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../api/config.php'; // pakai koneksi $mysqli

// Kalau sudah login, lempar ke dashboard
if (!empty($_SESSION['user_id'])) {
  header('Location: index.php');
  exit;
}

// Proses submit
$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $u = trim($_POST['username'] ?? '');
  $p = trim($_POST['password'] ?? '');

  if ($u === '' || $p === '') {
    $err = 'Username dan password wajib diisi.';
  } else {
    // di DB kamu kolomnya bernama password_hash tapi berisi plain text
    $stmt = $mysqli->prepare("SELECT id, username, role, nama FROM users WHERE username=? AND password_hash=? LIMIT 1");
    $stmt->bind_param('ss', $u, $p);
    $stmt->execute();
    $res = $stmt->get_result();
    $user = $res->fetch_assoc();

    if ($user) {
      $_SESSION['user_id']  = $user['id'];
      $_SESSION['username'] = $user['username'];
      $_SESSION['role']     = $user['role'];
      $_SESSION['nama']     = $user['nama'];
      header('Location: index.php');
      exit;
    } else {
      $err = 'Username / password salah.';
    }
  }
}
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Login</title>
  <style>
    body{font-family:system-ui;background:#0f172a;color:#e2e8f0;display:grid;place-items:center;height:100vh;margin:0}
    .card{background:#111827;padding:24px;border-radius:16px;min-width:320px;box-shadow:0 10px 30px rgba(0,0,0,.3)}
    input{width:100%;padding:10px;border-radius:10px;border:1px solid #374151;background:#0b1220;color:#e5e7eb;margin:6px 0}
    button{width:100%;padding:10px;border-radius:10px;border:0;background:#2563eb;color:white;font-weight:600;cursor:pointer}
    .err{background:#7f1d1d;color:#fecaca;padding:10px;border-radius:10px;margin-bottom:10px}
  </style>
</head>
<body>
  <div class="card">
    <h2 style="margin-top:0">Login</h2>
    <?php if ($err): ?><div class="err"><?= htmlspecialchars($err, ENT_QUOTES, 'UTF-8') ?></div><?php endif; ?>
    <form method="post" autocomplete="off">
      <label>Username</label>
      <input name="username" required>
      <label>Password</label>
      <input name="password" type="password" required>
      <button type="submit">Masuk</button>
    </form>
  </div>
</body>
</html>
